% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.extrapolateTrendExp}
\alias{mT.extrapolateTrendExp}
\title{Extrapolate a mortality trend exponentially}
\usage{
mT.extrapolateTrendExp(table, idx, up = TRUE)
}
\arguments{
\item{table}{A life table object (instance of a \code{mortalityTable} class) or a list, table or array of mortalityTable objects}

\item{idx}{Index (typically age) of the position of the fit}

\item{up}{Whether the fit is forward- or backward-facing (i.e. to old or young ages)}
}
\description{
Extrapolate a mortality trend in a \code{mortalityTable} object using an exponential function (i.e. the trend decreases towards 0 exponentially).
This is mainly used to extrapolate an observed age-specific trend to very old ages.
Existing trend function values above (or below, respectively) the \code{idx} are overwritten.
}
\examples{
mortalityTables.load("Austria_Annuities_AVOe2005R")
# extrapolate the trend exponentially from age 95 instead (overwriting the existing trend)
avoe2005exp = mT.extrapolateTrendExp(AVOe2005R.male, 95)
plotMortalityTrend(mT.setName(avoe2005exp, "AVÖ 2005R with trend extrapolated from age 85 up"),
                   AVOe2005R.male, Period = 2020, ages = 60:120)
}
