% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCAR.R
\name{MCAR.data}
\alias{MCAR.data}
\title{Introduces Missing Completely at Random (MCAR) Values into Data Sets.}
\usage{
MCAR.data(misg = NULL, perct = 10, dataList = "Data_List.dat", f.loc)
}
\arguments{
\item{misg}{A numeric vector of 0s and 1s specifying which items will contain missing values.
A value of 0 indicates the item will not include missingness, while 1 indicates missing values will be introduced.If omitted, all items are treated as eligible for missingness.}

\item{perct}{The percentage of missingness to be applied (default = 10 percents).}

\item{dataList}{The file name containing the list of previously generated data sets (e.g., "Data_List.dat"), either created by this package or by external software.}

\item{f.loc}{The directory path where both the original data sets and the "dataList" file are located.}
}
\description{
This function introduces missing values under the Missing Completely at Random (MCAR) mechanism into previously generated data sets (e.g., those produced by sim.skewed() or sim.normal()).
Missing values are inserted at random locations according to user specifications and are denoted as "NA" in the resulting files.
The modified data sets are saved as new files, preserving the original data sets.
In each data file, the first column contains the sample identifiers, while the subsequent columns show actual data with some entries replaced by NA.
Additionally, a file named "MCAR_List.dat" is created, listing the names of all data sets to which missing values were introduced.
}
\examples{

# Step 1: Generate data sets
fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))
floc<-tempdir()
sim.normal(nd=10, ss=100, fcors=fc, loading<-fl,  f.loc=floc)

 # Step 2: Introduce missing values

mis.items<-c(1,1,1,0,0,0,0,0)
dl<-"Data_List.dat"  # must be located in the working directory
MCAR.data(misg = mis.items, perct = 20, dataList = dl, f.loc=floc)

}
\author{
Fatih Orcan
}
