% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{plot.jointmotbf}
\alias{plot.jointmotbf}
\title{Bidimensional plots for \code{'jointmotbf'} objects}
\usage{
\method{plot}{jointmotbf}(
  x,
  type = "contour",
  ranges = NULL,
  orientation = c(5, -30),
  data = NULL,
  filled = TRUE,
  ticktype = "simple",
  ...
)
}
\arguments{
\item{x}{An object of class \code{'jointmotbf'}.}

\item{type}{A \code{"character"} string, either \emph{contour} or \emph{perspective}. It is set to \code{"contour"} by default.}

\item{ranges}{A \code{"numeric"} matrix containing the domain of the variables, by columns, which is used to specify the plotting range.}

\item{orientation}{A \code{"numeric"} vector indicating the perpective of the plot in degrees.
By default, it is set to \code{(5,-30)}.}

\item{data}{An object of class \code{"data.frame"} containing two columns only.
This argument is used to draw the points over the main plot. By default, it is set to \code{NULL}.}

\item{filled}{A logical argument; it is only used if \code{type = "contour"}.
is active. By default, it is \code{TRUE}, so filled contours are plotted.}

\item{ticktype}{A \code{"character"} string, either \emph{simple} or \emph{detailed}. By default, it is set to \code{"simple"},
which draws just an arrow parallel to the axis to indicate direction of increase. 
In contrast, \code{"detailed"} draws normal ticks. This argument is only used in the \code{"perspective"} plot.}

\item{\dots}{Further arguments to be passed to \link{plot}.}
}
\value{
A plot of the joint MoTBF.
}
\description{
PLot the perpective and the contour plots for joint MoTBF functions.
}
\examples{
## 1 .EXAMPLE
## Dataset
X <- data.frame(rnorm(500), rnorm(500))

## Joint function
dim <- c(3,3) 
param1 <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param1)
P

## Plots
plot(P)
plot(P, type = "perspective", orientation = c(90,0))

#############################################################################
## MORE EXAMPLES ############################################################
#############################################################################
\donttest{
## Dataset
X <- data.frame(rnorm(200,2), rexp(200, 1))

## Joint function
dim <- c(4,5)
param2 <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param2)
P

## Plots
plot(P)
plot(P, filled = FALSE, data = X)
plot(P, type = "perspective", orientation = c(10,180))
}
}
\seealso{
\link{jointMoTBF}
}
