% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stable_mixture_estimators.R
\name{run_estimations_with_gibbs}
\alias{run_estimations_with_gibbs}
\title{Run all EM-based estimations with Gibbs sampling (CRAN-safe)}
\usage{
run_estimations_with_gibbs(
  data,
  bw_sj,
  max_iter = 100,
  tol = 1e-04,
  save_plots = FALSE
)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{bw_sj}{Numeric. Bandwidth value (e.g., Silverman's rule).}

\item{max_iter}{Integer. Maximum number of EM iterations.}

\item{tol}{Numeric. Convergence tolerance.}

\item{save_plots}{Logical. Whether to save PNG plots to tempdir().}
}
\value{
Invisibly returns a list containing fitted parameters for each EM method with Gibbs.
}
\description{
Executes EM algorithms with Gibbs sampling on the input data.
Optionally saves mixture plots to a temporary directory.
}
