% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{em_alpha_stable}
\alias{em_alpha_stable}
\title{EM algorithm for alpha-stable mixture}
\usage{
em_alpha_stable(
  data,
  n_components = 2,
  max_iter = 100,
  tol = 1e-04,
  random_init = TRUE,
  debug = TRUE
)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{n_components}{Integer. Number of mixture components.}

\item{max_iter}{Integer. Maximum number of EM iterations.}

\item{tol}{Numeric. Convergence tolerance.}

\item{random_init}{Logical. Whether to use random initialization.}

\item{debug}{Logical. Whether to print debug information.}
}
\value{
List with estimated weights and parameters (alpha, beta, gamma, delta).
}
\description{
Estimates parameters of an alpha-stable mixture using EM with optional random initialization.
}
