% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineage_tracing.R
\name{vi_comparison}
\alias{vi_comparison}
\title{vi_comparison
We compute the variation of information (VI) between the partition provided
by \emph{new_classification} and \emph{old_classification}. The VI between a
random partitions (obtained with re-shuffle from original labels in
\emph{old_classification}) and \emph{old_classification} is also computed. A
distribution of VI values from random partitions is built. Finally, from the
comparison with this distribution, an empirical p value is given to the VI
of the unsupervised cluster analysis.}
\usage{
vi_comparison(old_classification, new_classification, number_iter)
}
\arguments{
\item{old_classification}{Character vector. First column of the dataframe
returned by function \emph{clustering_angular_distance} (first element of the
output).}

\item{new_classification}{Character vector.Second column of the dataframe
returned by function \emph{clustering_angular_distance} (first element of the
output).}

\item{number_iter}{Integer value. Specify how many random partition are
generated (starting from re-shuffle of labels in \emph{old_classification}).}
}
\value{
Numeric value (empirical p value).
}
\description{
vi_comparison
We compute the variation of information (VI) between the partition provided
by \emph{new_classification} and \emph{old_classification}. The VI between a
random partitions (obtained with re-shuffle from original labels in
\emph{old_classification}) and \emph{old_classification} is also computed. A
distribution of VI values from random partitions is built. Finally, from the
comparison with this distribution, an empirical p value is given to the VI
of the unsupervised cluster analysis.
}
\seealso{
\url{https://www.rdocumentation.org/packages/mcclust/versions/1.0/topics/vi.dist}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
