% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{is.linear}
\alias{is.linear}
\title{Linear class}
\usage{
is.linear(x)
}
\arguments{
\item{x}{variable or list.}
}
\value{
\code{TRUE} if the object or all objects are of class \code{linear}.
}
\description{
Test if a variable or variable list is/are linear-object(s).
}
\examples{
# TRUE return
r1 <- MicrobialGrowth(example_data$time, example_data$y1, model="linear")
r2 <- MicrobialGrowth.create(N0 = 0.14, Nmax = 1.43, mu = 0.07, lambda = 45,
                                   xlim = c(0, 100), model="linear")
is.linear(r1)
is.linear(r2)
is.linear(c(r1, r2))
is.linear(list(r1,r2))

# FALSE return
is.linear(1)
is.linear(list())
is.linear(c(r1, r2, 1))
is.linear(list(r1, r2, 1))
}
