% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\title{Performance}
\usage{
performance(
  data,
  actual,
  predicted,
  w = NULL,
  metrics = rmse,
  key = "metric",
  value = "value",
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} with columns \code{actual}, \code{predicted}, and optionally \code{w}.}

\item{actual}{The column name in \code{data} referring to actual values.}

\item{predicted}{The column name in \code{data} referring to predicted values.}

\item{w}{The optional column name in \code{data} referring to case weights.}

\item{metrics}{Either a function or a named list of functions.
Each function represents a metric and has four arguments:
\itemize{
\item \code{observed},
\item \code{predicted},
\item \verb{case weights}, and
\item \code{...}.
}

If not a named list but a single function, the name of the function is guessed by
\code{deparse(substitute(...))}, which would not provide the actual name of the
function if called within \code{\link[=lapply]{lapply()}} etc. In such cases, you can pass a named
list with one element, e.g., \code{list(rmse = rmse)}.}

\item{key}{Name of the resulting column containing the name of the metric.
Defaults to "metric".}

\item{value}{Name of the resulting column with the value of the metric.
Defaults to "value".}

\item{...}{Further arguments passed to the metric functions. E.g., if the metric
is \code{\link[=r_squared]{r_squared()}}, you could pass the relevant deviance function as additional
argument (see examples).}
}
\value{
Data frame with one row per metric and two columns: \code{key} and \code{value}.
}
\description{
Applies one or more metrics to a \code{data.frame} containing columns with
actual and predicted values as well as an optional column with case weights.
The results are returned as a \code{data.frame} and can be used in a pipe.
}
\examples{
ir <- iris
fit_num <- lm(Sepal.Length ~ ., data = ir)
ir$fitted <- fit_num$fitted
performance(ir, "Sepal.Length", "fitted")
performance(ir, "Sepal.Length", "fitted", metrics = r_squared)
performance(
  ir,
  actual = "Sepal.Length",
  predicted = "fitted",
  metrics = c(`R-squared` = r_squared, rmse = rmse)
)
performance(
  ir,
  actual = "Sepal.Length",
  predicted = "fitted",
  metrics = r_squared,
  deviance_function = deviance_gamma
)
performance(
  ir,
  actual = "Sepal.Length",
  predicted = "fitted",
  metrics = r_squared,
  deviance_function = deviance_tweedie,
  tweedie_p = 2
)
}
