% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethComp-package.R
\docType{data}
\name{sbp.MC}
\alias{sbp.MC}
\title{A MCmcmc object from the sbp data}
\format{
The format is a \code{\link{MCmcmc}} object.
}
\description{
This object is included for illustrative purposes. It is a result of using
\code{\link{MCmcmc}}, with \code{n.iter=100000} on the dataset
\code{\link{sbp}} from this package.
}
\details{
The basic data are measurements of systolic blood pressure from the
\code{\link{sbp}} dataset. Measurements are taken to be linked within
replicate.  The code used to generate the object was: \preformatted{
library(MethComp) data( sbp ) spb <- Meth( sbp ) sbp.MC <- MCmcmc( sbp,
linked=TRUE, n.iter=100000, program="JAGS" ) ) }
}
\examples{

data(sbp.MC)
# How was the data generated
attr(sbp.MC,"mcmc.par")

# Traceplots
trace.MCmcmc(sbp.MC)
trace.MCmcmc(sbp.MC,"beta")

# A MCmcmc object also has class mcmc.list, so we can use the
# standard coda functions for convergence diagnostics:
# acfplot( subset.MCmcmc(sbp.MC,subset="sigma") )

# Have a look at the correlation between the 9 variance parameters
pairs( sbp.MC )

# Have a look at whether the MxI variance components are the same between methods:
\dontrun{
pairs( sbp.MC, subset=c("mi"), eq=TRUE,
        panel=function(x,y,...)
              {
               abline(0,1)
               abline(v=median(x),h=median(y),col="gray")
               points(x,y,...)
              }
        ) }

}
\keyword{datasets}
