% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atp.MVT.R
\name{atp.MVT}
\alias{atp.MVT}
\title{Atypical Detection Points Using Matrix-Variate t Hidden Markov Models}
\usage{
atp.MVT(Y, M, U, V, class, epsilon)
}
\arguments{
\item{Y}{An array with dimensions \code{p} x \code{r} x \code{num} x \code{t}, where \code{p} is the number of
variables in the rows of each data matrix, \code{r} is the number of variables in the columns of each
data matrix, \code{num} is the number of data observations, and \code{t} is the number of time points.}

\item{M}{An array with dimensions \code{p} x \code{p} x \code{k}, where \code{k} is the number of states, containing the mean matrices.}

\item{U}{An array with dimensions \code{p} x \code{p} x \code{k}, where \code{k} is the number of states, containing the row covariance (scale) matrices.}

\item{V}{An array with dimensions \code{r} x \code{r} x \code{k}, where \code{k} is the number of states, containing the column covariance (scale) matrices.}

\item{class}{An \code{num} x \code{t} matrix containing the state memberships.}

\item{epsilon}{A numeric value specifying the selected percentile of the chi-squared distribution with \code{pr} degrees of freedom.}
}
\value{
An \code{num} x \code{t} matrix containing, for each observation and time, a 0 if it that matrix is typical and 1 otherwise.
}
\description{
Detects atypical matrices via matrix-variate t Hidden Markov Models given a specified value of \code{epsilon}.
}
\examples{
data("simData2")
Y <- simData2$Y
init <- Eigen.HMM_init(Y = Y, k = 2, density = "MVT", mod.row = "EEE", mod.col = "EE", nstartR = 1)
fit <- Eigen.HMM_fit(Y = Y, init.par = init, nThreads = 1)
atp <- atp.MVT(Y = Y, M = fit[["results"]][[1]][[1]][[1]][["M"]],
              U = fit[["results"]][[1]][[1]][[1]][["U"]],
              V = fit[["results"]][[1]][[1]][[1]][["V"]],
              class = fit[["results"]][[1]][[1]][[1]][["class"]],
              epsilon = 0.99)
which(atp==1)
which(simData2[["atp.tr"]]==1)
}
