% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.mimids.R
\name{as.mimids}
\alias{as.mimids}
\alias{as.mimids.default}
\title{Create a \code{mimids} object}
\usage{
as.mimids(x, ...)

\method{as.mimids}{default}(x, datasets, ...)
}
\arguments{
\item{x}{A list of \code{matchit} objects, each the output of a call to \code{\link[MatchIt:matchit]{MatchIt::matchit()}} on an imputed dataset.}

\item{...}{Ignored.}

\item{datasets}{This argument specifies the datasets containing the exposure and the potential confounders called in the \code{formula}. This argument must be an object of the \code{mids} or \code{amelia} class, which is typically produced by a previous call to \code{mice()} function from the \pkg{mice} package or to \code{amelia()} function from the \pkg{Amelia} package (the \pkg{Amelia} package is designed to impute missing data in a single cross-sectional dataset or in a time-series dataset, currently, the \pkg{MatchThem} package only supports the former datasets).}
}
\value{
A \code{\link{mimids}} object.
}
\description{
Creates a \code{mimids} object from a list of \code{matchit} objects and an imputed dataset.
}
\details{
The matched datasets are stored as though \code{matchthem()} was called with \code{approach = "within"}.
}
\examples{

#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5,
                               printFlag = FALSE)

#Matching the multiply imputed datasets manually
match.list <- lapply(1:5, function(i) {
  MatchIt::matchit(OSP ~ AGE + SEX + BMI + RAC + SMK,
                   mice::complete(imputed.datasets, i),
                   method = 'nearest')
})

#Creating mimids object
matched.datasets <- as.mimids(match.list,
                              imputed.datasets)
}
\seealso{
\code{\link[=matchthem]{matchthem()}}, \code{\link{mimids}}, \code{\link[MatchIt:matchit]{MatchIt::matchit()}}
}
