% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MajMinOptim.R
\name{MajMinOptim}
\alias{MajMinOptim}
\title{majorization-minimization optimization}
\usage{
MajMinOptim(X, Z, M, eps, lambda)
}
\arguments{
\item{X}{matrix of data  (dim 1: samples (must be equal to dim 1 of X), dim 2: attributes (must be equal to dim 2 of X))}

\item{Z}{is a n by k matrix where for all i and j, zi,j is abinary variable that is equal to 1 if the case i is assigned to cluster j and zero otherwise. (dim 1: samples (must be equal to dim 1 of X), dim 2: attributes (must be equal to dim 2 of X))}

\item{M}{initial seleted centroids (randomly or another method)}

\item{eps}{a threshold value assumed as 0.0001}

\item{lambda}{a threshold value assumed as 0.5}
}
\value{
The optimized majorization-minimization centers.
}
\description{
Finding the optimized majorization-minimization centers
}
\examples{
{
X=rbind(matrix(rnorm(1000*2 ,4,.1),1000,2),matrix(rnorm(1000*2, 3, 0.2),1000,2))
M <- X[sample(nrow(X), 2),]
distsToCenters <- Euclid(X, M)
clusters <- apply(distsToCenters, 1, which.min)
Z <- matrix(0, nrow = NROW(X), ncol = 1)
for(i in 1:NROW(X))
if (clusters[[i]] == 1)
    Z[i,]=clusters[[i]]
Z=cbind(Z, 1-Z)
MajMinOptim(X,Z,M ,eps=1e-4, lambda=.5)
}
}
