% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaddisonLeaders.R
\name{MaddisonLeaders}
\alias{MaddisonLeaders}
\title{Identify leading countries}
\usage{
MaddisonLeaders(
  except = character(0),
  y = "gdppc",
  group = "ISO",
  data = MaddisonData::MaddisonData,
  x = "year"
)
}
\arguments{
\item{except}{either NULL to select all the data in \code{MaddisonData} or a
character vector of \code{group} codes to EXCLUDE, e.g., so the result reflects
apparent  technology leaders, excluding countries whose high \code{gdppc} may be
due to a dominant position in a single commodity.}

\item{y}{name of column in \code{data} to consider. Default = \code{gdppc}.}

\item{group}{name of column in \code{data} as the grouping variable. Default =
\code{ISO}.}

\item{data}{\code{\link{data.frame}} or \code{\link[tibble:tibble]{tibble::tibble}} with first two columns
being \code{ISO} and \code{year} and \code{y} being the name of another column.}

\item{x}{time variable. Default = \code{year}.}
}
\value{
an object of class \code{c('MaddisonLeaders', 'data.frame')}, with
columns

\itemize{
\item \verb{paste0(x, 'Begin)},
\item \code{paste0(x, 'End')},
\item \code{paste0(y, '0')},
\item \code{paste0(y, '1')}, and
\item \code{{{group}}}
\item {\verb{paste0('d', x, '0') = }
\code{paste0(x, 'End') - paste0(x, 'Begin') + min(dx)}, where
\code{dx = min(diff(sort(unique(data[, x]))))}
}
\item {
\verb{paste0('d', x, '1') = }
\code{c(tail(paste0(x, 'Begin'), -1) - head(paste0(x, 'End'), -1), NA)}
(defaults:
\code{dy0 = yearEnd - yearBegin +1} and
\code{dy1 = c(tail(yearBegin, -1) - head(yearEnd, -1), NA)}
)
}
}

(defaults:
\itemize{
\item \code{yearBegin},
\item \code{yearEnd},
\item \code{gdppc0},
\item \code{gdppc1}, and
\item \code{ISO}, plus
\item \code{dyear0 = yearEnd - yearBegin + 1} and
\item \code{dyear1 = c(tail(yearBegin, -1) - head(yearEnd, -1), NA)}
}

with an attribute \code{LeaderByYear} = a \code{data.frame} with columns, \code{{{x}}},
\code{paste0('max', y)}, and \code{{{group}}} (defaults: \code{year}, \code{maxgdppc}, \code{ISO}).
}
\description{
\code{MaddisonLeaders} computes the countries with the highest \code{gdppc} for each
\code{year}.
}
\examples{
Leaders0 <- MaddisonLeaders() # max GDPpc for each year. 

# Presumed technology leaders without commodity leaders with narrow 
# economies 
Leaders1 <- MaddisonLeaders(c('ARE', 'KWT', 'QAT')) 

# since 1600 
MadDat1600 <- subset(MaddisonData, year>1600)
Leaders1600 <- MaddisonLeaders(c('ARE', 'KWT', 'QAT'), data=MadDat1600)

# max pop by region within percentiles of gdppc
noGDP <- is.na(MaddisonData$gdppc)
MadDat <-MaddisonData[!noGDP, ]
gdpPcts <- quantile(MadDat$gdppc, seq(0, 1, .01), na.rm=TRUE)
gdpPct <- unique(as.numeric(gdpPcts[-1]))
gdpPc <-c(gdpPct[-100], tail(gdpPct, 1)*(1+sqrt(.Machine$double.eps)))
gdp100 <- MadDat$gdppc
nObs <- nrow(MadDat)
for(i in 1:nObs){gdp100[i] <- min(gdpPc[MadDat$gdppc[i]<gdpPc])}
MadDat$gdp100 <- gdp100
MadDat$region <- MaddisonCountries[MadDat$ISO, 'region', drop=TRUE]
MadPopRgnGDP<-MaddisonLeaders(y='pop',group='region',data=MadDat,x='gdp100')

}
\keyword{manip}
