% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantextnetwork.r
\name{LEMMA}
\alias{LEMMA}
\title{Persian Lemmatization}
\usage{
LEMMA(Y, TYPE = TYPE.org)
}
\arguments{
\item{Y}{A character vector of Persian words.}

\item{TYPE}{A vector of suffix types for modification.}
}
\value{
Returns a character vector where each element is the lemmatized
form of the corresponding element in the input vector `Y`.
Lemmatization involves removing inflectional endings and returning
the word to its base or dictionary form. The length of the returned
vector matches the length of the input vector, and each word is
lemmatized independently based on the specified suffix types in `TYPE`.
}
\description{
This function performs lemmatization on a vector of Persian words.
}
\examples{
\dontrun{
  words <- c("Persian text here")
  lemmatized_words <- LEMMA(words, TYPE)
}
}
