% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{confusion}
\alias{confusion}
\alias{ConfusionMatrix}
\title{Confusion Matrix}
\usage{
confusion(
  x,
  y = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  na.rm = TRUE,
  ...
)

ConfusionMatrix(data = NA, ordered = FALSE)
}
\arguments{
\item{x}{factor of \link[=response]{observed responses} or \link{resample}
result containing observed and predicted responses.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{weights}{numeric vector of non-negative
\link[=case_weights]{case weights} for the observed \code{x} responses
[default: equal weights].}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.  If \code{NULL}, then factor responses are
summed directly over predicted class probabilities, whereas a default
cutoff of 0.5 is used for survival probabilities.  Class probability
summations and survival will appear as decimal numbers that can be
interpreted as expected counts.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{...}{arguments passed to other methods.}

\item{data}{square matrix, or object that can be converted to one, of
cross-classified predicted and observed values in the rows and columns,
respectively.}

\item{ordered}{logical indicating whether the confusion matrix row and
columns should be regarded as ordered.}
}
\value{
The return value is a \code{ConfusionMatrix} class object that inherits from
\code{table} if \code{x} and \code{y} responses are specified or a
\code{ConfusionList} object that inherits from \code{list} if \code{x} is a
\code{Resample} object.
}
\description{
Calculate confusion matrices of predicted and observed responses.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

res <- resample(Species ~ ., data = iris, model = GBMModel)
(conf <- confusion(res))
plot(conf)
}

}
\seealso{
\code{\link{c}}, \code{\link{plot}}, \code{\link{summary}}
}
