% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{mst}
\alias{mst}
\title{Multiscalar Typology (3 deviations)}
\usage{
mst(x, gdevrel, tdevrel, sdevrel, threshold, superior = FALSE)
}
\arguments{
\item{x}{a sf object or a dataframe including gdev, tdev and sdev columns.}

\item{gdevrel}{name of the general relative deviation variable in x.}

\item{tdevrel}{name of the territorial relative deviation variable in x.}

\item{sdevrel}{name of the spatial relative deviation variable in x.}

\item{threshold}{defined to build the typology (100 is considered as the average).}

\item{superior}{if TRUE, deviation values must be greater than threshold. If FALSE, deviation values must be lower than threshold.}
}
\value{
a vector in x including the mst typology. Values are classified in 
8 classes following their respective position above/under the threshold:
\itemize{Typology (which deviation is above/under the threshold):
\item{0: none}
\item{1: G }
\item{2: T}
\item{3: G and T}
\item{4: S}
\item{5: G and S}
\item{6: T and S}
\item{7: G, T and S}
}
}
\description{
Compute a multiscalar typology according to the three relative 
deviations (general: G, territorial: T and spatial: S). The elementary units are classified
in eight classes according to their three relative positions.
}
\examples{
# Load data
library(sf)
com <- st_read(system.file("metroparis.gpkg", package = "MTA"), layer = "com", quiet = TRUE)

# Prerequisite  - Compute the 3 deviations
com$gdev <- gdev(x = com, var1 = "INC", var2 = "TH")
com$tdev <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT")
com$sdev <- sdev(x = com, var1 = "INC", var2 = "TH", order = 1)

# Multiscalar typology - wealthiest territorial units
# Compute mst
com$mstW <- mst(x = com, gdevrel = "gdev", tdevrel = "tdev", sdevrel = "sdev", 
                threshold = 125, superior = TRUE)

#Multiscalar typology - lagging territorial units
# Compute mst
com$mstP <- mst(x = com, gdevrel = "gdev", tdevrel = "tdev", sdevrel = "sdev", 
                threshold = 75, superior = FALSE)
}
