% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_forest-methods.R
\docType{methods}
\name{mr_forest}
\alias{mr_forest}
\alias{mr_forest,MRInput-method}
\title{Draw a forest plot of causal estimates}
\usage{
mr_forest(
  object,
  alpha = 0.05,
  snp_estimates = TRUE,
  methods = "ivw",
  ordered = FALSE
)

\S4method{mr_forest}{MRInput}(
  object,
  alpha = 0.05,
  snp_estimates = TRUE,
  methods = "ivw",
  ordered = FALSE
)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{alpha}{The significance level used to calculate the confidence intervals. The default value is 0.05, corresponding to 95\% confidence intervals.}

\item{snp_estimates}{Whether to plot the variant-specific estimates. Defaults to \code{TRUE}.}

\item{methods}{Takes a string of computation methods used to calculate estimates. Defaults to \code{"ivw"}. Options are: \code{"median"} (simple median estimate), \code{"wmedian"} (weighted median estimate), \code{"egger"} (MR-Egger estimate), \code{"mbe"} (mode-based estimate), \code{"conmix"} (contamination mixture estimate), and \code{"maxlik"} (maximum likelihood estimate).}

\item{ordered}{Determines by whether to arrange the variant-specific estimates in ascending order. Defaults to \code{FALSE}.}
}
\description{
The \code{mr_forest} function draws a forest plot of causal estimates. The default option plots the variant-specific causal estimates (\code{by/bx}) and the estimate from the \code{mr_ivw} function using default settings (assuming variants are uncorrelated, random-effects for 4+ variants). Options allow users to plot estimates from a variety of different methods.
}
\details{
As the function produces a \code{ggplot} object, graphical parameters can be changed by adding commands from the \code{ggplot2} package.
}
\examples{
mr_forest(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  alpha = 0.01, ordered = TRUE)
mr_forest(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  methods = c("ivw", "wmedian", "egger"), snp_estimates = FALSE)
forest = mr_forest(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse))
# how to change x-axis limits
# library(ggplot2)
# forest2 = forest + coord_cartesian(xlim=c(-5,5))
# forest2

}
