% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMNB.R
\name{rMNB}
\alias{rMNB}
\title{Generating Multivariate Negative Binomial Data}
\usage{
rMNB(n, mi, formula, p.fix)
}
\arguments{
\item{n}{Length of the sample.}

\item{mi}{replicates on the ith subject or cluster.}

\item{formula}{The structure matrix of covariates of dimension n x p (in models that include an intercept x
should contain a column of ones)}

\item{p.fix}{Vector of theoretical regression parameters of length p.}
}
\value{
Generated response (\eqn{Y_{ij}})
}
\description{
It simulates a multivariate response variable, \eqn{Y_{ij}}, that is jth measurement
taken on the ith subject or cluster, i = 1,...,n and j= 1,...,mi.
}
\examples{

n <- 100
mi <- 3
x1 <- rep(rnorm(n,0,1),each=mi)
x2 <- rep(c(0,1),each=150)
p.fix <- c(10,2.0,0.5,1)

#generating a sample
sample.ex <- rMNB(n=n,mi=mi,formula=~x1+x2, p.fix=p.fix)
head(sample.ex)

}
\author{
Jalmar M F Carrasco <carrascojalmar@gmail.com>,
Cristian M Villegas Lobos <master.villegas@gmail.com> and Lizandra C Fabio <lizandrafabio@gmail.com>
}
