#' Hessian: Power function
#'
#' This function evaluates the Hessian matrix of the power function \deqn{f(x_1,x_2,\ldots,x_k)=(\sum_{i=1}^kc_ix_{i})^{c_{k+1}}.}
#'
#' @param parameter The value of the parameters \eqn{x_1,x_2,\ldots,x_k}.
#' @param coefficient The value of the coefficients \eqn{c_1,c_2,\ldots,c_k,c_{k+1}}.
#'
#' @return
#' Hessian matrix of the power function.
#'
#' @keywords internal
#' @noRd
Hessian_Power<-function(parameter,coefficient)
{
  return(sum(parameter*coefficient[-length(coefficient)])^(coefficient[length(coefficient)]-2)*(coefficient[length(coefficient)]-1)*coefficient[length(coefficient)]*(coefficient[-length(coefficient)]%*%t(coefficient[-length(coefficient)])))
}
