% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchicalFWER.R
\name{selFWER}
\alias{selFWER}
\title{Selection from hierarchical testing with FWER control}
\usage{
selFWER(out, alpha = 0.05)
}
\arguments{
\item{out}{output of \link{hierarchicalFWER} function}

\item{alpha}{control level for test}
}
\value{
a list containing:
\describe{
  \item{toSel}{vector of boolean. TRUE if the group is selected}
  \item{groupId}{Names of groups}
  }
}
\description{
Select groups from hierarchical testing procedure with FWER control (\link{hierarchicalFWER})
}
\details{
Only outer nodes (rejected groups without rejected children) are returned as TRUE.
}
\examples{
set.seed(42)
X <- simuBlockGaussian(50, 12, 5, 0.7)
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
res <- MLGL(X, y)
test <- hierarchicalFWER(X, y, res$group[[20]], res$var[[20]])
sel <- selFWER(test, alpha = 0.05)
}
\references{
Meinshausen, Nicolai. "Hierarchical Testing of Variable Importance." Biometrika 95.2 (2008): 265-78.
}
\seealso{
\link{hierarchicalFWER}
}
