% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{table}
\alias{table}
\alias{table.default}
\alias{table.mic_validation}
\title{Table}
\usage{
table(x, ...)

\method{table}{default}(x, ...)

\method{table}{mic_validation}(
  x,
  format = "flextable",
  fill_dilutions = TRUE,
  bold = TRUE,
  ea_color = NULL,
  gold_standard_name = "Gold Standard",
  test_name = "Test",
  ...
)
}
\arguments{
\item{x}{mic_validation S3 object}

\item{...}{further arguments}

\item{format}{simple or flextable}

\item{fill_dilutions}{Fill dilutions that are not present in the data in
order to match the y- and x- axes}

\item{bold}{Bold cells where essential agreement is TRUE}

\item{ea_color}{Background color for essential agreement cells}

\item{gold_standard_name}{Name of the gold standard to display in output}

\item{test_name}{Name of the test to display in output}
}
\value{
table or flextable object
}
\description{
Table
}
\examples{
gold_standard <- c("<0.25", "8", "64", ">64")
test <- c("<0.25", "2", "16", "64")
val <- compare_mic(gold_standard, test)
table(val)
}
