% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-CLEAVRMF.R
\name{cubeCLEAVRMF}
\alias{cubeCLEAVRMF}
\title{Inheritance Cube: CLEAVR - Cleave and Rescue}
\usage{
cubeCLEAVRMF(
  cM1 = 1,
  cM2 = 1,
  cF1 = 1,
  cF2 = 1,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM1}{Male cutting rate at first locus}

\item{cM2}{Male cutting rate at second locus}

\item{cF1}{Female cutting rate at first locus}

\item{cF2}{Female cutting rate at second locus}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a novel cube from the Akbari lab. There are 2 loci: the first is a female
fertility locus (e.g. doubleSex), where the Cas, gRNAs, and a recoded essential
gene go. This locus is inherited in a Mendelian fashion, but is also targeted for
destruction by the homing allele. The second locus involves
an essential gene, for both males and females, and this is the target of the
gRNAs at the first locus. No homing is performed, it is simply destroyed. There
is different cutting rates in males and females, with no possibility for a rescuing
resistant allele. Females homozygous for the H or B alleles at locus 1 are viable but infertile,
while males are unaffected. All animals homozygous at locus two must contain the
recoded copy at locus 1 to be viable. This version corresponds to the homing
construct being autosomal.
}
