% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEA.R
\name{plot.CEA}
\alias{plot.CEA}
\title{Plot cost-effectiveness plane}
\usage{
\method{plot}{CEA}(
  x,
  xlim = c(-1, 1) * max(abs(x$stats$diffE)),
  ylim = c(-1, 1) * max(abs(x$stats$diffC)),
  xlab = "Incremental effects",
  ylab = sprintf("Incremental costs (\%s)", x$currencyUC),
  las = 1,
  ...
)
}
\arguments{
\item{x}{object of class \code{CEA}, created by \code{\link{CEA}}}

\item{xlim}{limits of x axis (i.e., the axis of the incremental effects)}

\item{ylim}{limits of y axis (i.e., the axis of the incremental costs)}

\item{xlab}{label of x axis}

\item{ylab}{label of y axis}

\item{las}{style of the axis labels (see \code{\link[graphics]{par}})}

\item{...}{other arguments to be passed to the \code{plot} and \code{abline}
(for the zero lines of the axes) functions.}
}
\value{
\code{plot.CEA} returns a plot
}
\description{
Plot cost-effectiveness plane
}
\examples{
CEA(gnomes, insulationMethod, Costs, diffHATS, 5000, "acorns") |>
  plot()
}
\author{
Mathijs Deen
}
