% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Spectrum.R
\name{plot_RLum.Data.Spectrum}
\alias{plot_RLum.Data.Spectrum}
\title{Plot function for an RLum.Data.Spectrum S4 class object}
\usage{
plot_RLum.Data.Spectrum(
  object,
  par.local = TRUE,
  plot.type = "contour",
  optical.wavelength.colours = TRUE,
  bg.spectrum = NULL,
  bg.channels = NULL,
  bin.rows = 1,
  bin.cols = 1,
  norm = NULL,
  rug = TRUE,
  limit_counts = NULL,
  xaxis.energy = FALSE,
  legend.text = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Spectrum} or \link{matrix} (\strong{required}):
S4 object of class \code{RLum.Data.Spectrum} or a \code{matrix} containing count
values of the spectrum.\cr
Please note that in case of a matrix row names and col names are set
automatically if not provided.}

\item{par.local}{\link{logical} (\emph{with default}):
use local graphical parameters for plotting, e.g. the plot is shown in one
column and one row. If \code{par.local = FALSE} global parameters are inherited.}

\item{plot.type}{\link{character} (\emph{with default}):
for a 3D-plot use \code{"persp"} or \code{"interactive"}; for a 2D-plot you can use
\code{"image"}, \code{"contour"}, \code{"single"} or \code{"multiple.lines"} (along the time or
temperature axis) or \code{"transect"} (along the wavelength axis).}

\item{optical.wavelength.colours}{\link{logical} (\emph{with default}):
use optical wavelength colour palette. Note: For this, the spectrum range is
limited: \code{c(350,750)}. Own colours can be set with the argument \code{col}. If
you provide already binned spectra, the colour assignment is likely to be
wrong, since the colour gradients are calculated using the bin number.}

\item{bg.spectrum}{\linkS4class{RLum.Data.Spectrum} or \link{matrix} (\emph{optional}):
spectrum used for the background subtraction. The background spectrum should
be measured using the same setting as the signal spectrum. The argument
\code{bg.channels} controls how the subtraction is performed: if \code{bg.channels}
is not specified or the number of channels is identical between the signal
and background spectra, a channel-wise subtraction is performed; otherwise,
the \emph{arithmetic mean} is calculated and subtracted from the signal.}

\item{bg.channels}{\link{vector} (\emph{optional}):
channels used for background subtraction. If the number of channels is
identical between the signal and background spectra, a channel-wise
subtraction is performed; otherwise this number is used to select channels
for calculating the \emph{arithmetic mean}  If a spectrum is provided via
\code{bg.spectrum}, this argument only works on the background spectrum.

\strong{Note:} Background subtraction is applied prior to channel binning!}

\item{bin.rows}{\link{integer} (\emph{with default}):
allow summing-up wavelength channels (horizontal binning),
e.g. \code{bin.rows = 2} two channels are summed up.
Binning is applied after the background subtraction.}

\item{bin.cols}{\link{integer} (\emph{with default}):
allow summing-up channel counts (vertical binning) for plotting,
e.g. \code{bin.cols = 2} two channels are summed up.
Binning is applied after the background subtraction.}

\item{norm}{\link{character} (\emph{optional}):
Normalise data to the maximum (\code{norm = "max"}) or minimum (\code{norm = "min"})
count values. The normalisation is applied after binning.}

\item{rug}{\link{logical} (\emph{with default}):
enable/disable colour rug. Currently only implemented for plot
type \code{multiple.lines} and \code{single}.}

\item{limit_counts}{\link{numeric} (\emph{optional}):
value to limit all count values to this value, i.e. all count values above
this threshold will be replaced by this threshold. This is helpful
especially in case of TL-spectra.}

\item{xaxis.energy}{\link{logical} (\emph{with default}): enable/disable using energy
instead of wavelength on the x-axis. Function \link{convert_Wavelength2Energy}
is used to perform the conversion.

\strong{Note:} Besides being used in setting the axis, with this option the
the spectrum is recalculated in terms of intensity, see details.}

\item{legend.text}{\link{character} (\emph{with default}):
possibility to provide own legend text. This argument is only considered for
plot types providing a legend, e.g. \code{plot.type = "transect"}.}

\item{plot}{\link{logical} (\emph{with default}): enable/disable the plot output. If
the plot output is disabled, the \link{matrix} used for the plotting and the
calculated colour values (as attributes) are returned. This way, the
(binned, transformed etc.) output can be used in other functions and
packages, such as plotting with the package \code{'plot3D'}.}

\item{...}{further arguments and graphical parameters that will be passed
to the \code{plot} function.}
}
\value{
Returns a plot and the transformed \code{matrix} used for plotting with some
useful attributes such as \code{colour} and \code{pmat} (the transpose matrix from
\link[graphics:persp]{graphics::persp}).
}
\description{
The function provides a standardised plot output for spectrum data of an
\linkS4class{RLum.Data.Spectrum} class object. The purpose of this function is to
provide easy and straightforward spectra plotting, not a fully customised
access to all plot parameters. If this is wanted, standard R plot
functionality should be used instead.

\strong{Matrix structure} \cr (cf. \linkS4class{RLum.Data.Spectrum})
\itemize{
\item \code{rows} (x-values): wavelengths/channels (\code{xlim}, \code{xlab})
\item \code{columns} (y-values): time/temperature (\code{ylim}, \code{ylab})
\item \code{cells} (z-values): count values (\code{zlim}, \code{zlab})
}

\emph{Note: This nomenclature is valid for all plot types of this function!}

\strong{Nomenclature for value limiting}
\itemize{
\item \code{xlim}: Limits values along the wavelength axis
\item \code{ylim}: Limits values along the time/temperature axis
\item \code{zlim}: Limits values along the count value axis
}

\strong{Details on the plot functions}

Spectrum is visualised as 3D or 2D plot. Both plot types are based on
internal R plot functions.

\strong{\code{plot.type = "persp"}}

Arguments that will be passed to \link[graphics:persp]{graphics::persp}:
\itemize{
\item \code{shade}: default is \code{0.4}
\item \code{phi}: default is \code{15}
\item \code{theta}: default is \code{-30}
\item \code{lphi}: default is \code{15}
\item \code{ltheta}: default is \code{-30}
\item \code{expand}: default is \code{1}
\item \code{axes}: default is \code{TRUE}
\item \code{box}: default is \code{TRUE}; accepts \code{"alternate"} for a custom plot design
\item \code{ticktype}: default is \code{detailed}, \code{r}: default is \code{10}
}

\strong{Note:} Further parameters can be adjusted via \code{par}. For example
to set the background transparent and reduce the thickness of the lines use:
\code{par(bg = NA, lwd = 0.7)} before the function call.

\strong{\code{plot.type = "single"}}

Per frame a single curve is returned. Frames are time or temperature
steps.

-\code{frames}: pick the frames to be plotted (depends on the binning!). Check without
this setting before plotting.

\strong{\code{plot.type = "multiple.lines"}}

All frames plotted in one frame.

-\code{frames}: pick the frames to be plotted (depends on the binning!). Check without
this setting before plotting.

\strong{\code{plot.type = "image"} or \code{plot.type = "contour"}}

These plot types use the R functions \link[graphics:image]{graphics::image} or \link[graphics:contour]{graphics::contour}.
The advantage is that many plots can be arranged conveniently using standard
R plot functionality. If \code{plot.type = "image"} a contour is added by default,
which can be disabled using the argument \code{contour = FALSE} to add own contour
lines of choice.

\strong{\code{plot.type = "transect"}}

Depending on the selected wavelength/channel range a transect over the
time/temperature (y-axis) will be plotted along the wavelength/channels
(x-axis). If the range contains more than one channel, values (z-values) are
summed up. To select a transect use the \code{xlim} argument, e.g.
\code{xlim = c(300,310)} plot along the summed up count values of channel
300 to 310.

\strong{Further arguments that will be passed (depending on the plot type)}

\code{xlab}, \code{ylab}, \code{zlab}, \code{xlim}, \code{ylim}, \code{zlim}, \code{main}, \code{mtext},
\code{box}, \code{pch}, \code{type} (\code{"single"}, \code{"multiple.lines"}, \code{"interactive"}),
\code{col}, \code{border}, \code{lwd}, \code{bty}, \code{showscale} (\code{"interactive"}, \code{"image"})
\code{contour}, \code{contour.col} (\code{"image"}), \code{labcex} (\code{"image"}, \code{"contour"}),
\code{n_breaks} (\code{"image"}), \code{legend} (\code{TRUE}/\code{FALSE}),
\code{legend.pos} (\code{"image"}), \code{legend.horiz} (\code{TRUE}/\code{FALSE} | \code{"image"})
}
\note{
Not all additional arguments (\code{...}) will be passed similarly!
}
\section{Function version}{
 0.6.13
}

\examples{

##load example data
data(ExampleData.XSYG, envir = environment())

##(1)plot simple spectrum (2D) - image
plot_RLum.Data.Spectrum(
 TL.Spectrum,
 plot.type="image",
 xlim = c(310,750),
 ylim = c(0,300),
 bin.rows=10,
 bin.cols = 1)

##(2) plot spectrum (3D)
plot_RLum.Data.Spectrum(
  TL.Spectrum,
  plot.type="persp",
  xlim = c(310,750),
  ylim = c(0,100),
  bin.rows=10,
  bin.cols = 1)

##(3) plot spectrum on energy axis
##please note the background subtraction
plot_RLum.Data.Spectrum(TL.Spectrum,
plot.type="persp",
ylim = c(0,200),
bin.rows=10,
bg.channels = 10,
bin.cols = 1,
xaxis.energy = TRUE)

##(4) plot multiple lines (2D) - multiple.lines (with ylim)
plot_RLum.Data.Spectrum(
 TL.Spectrum,
 plot.type="multiple.lines",
 xlim = c(310,750),
 ylim = c(0,100),
 bin.rows=10,
 bin.cols = 1)

\dontrun{
 ##(4) interactive plot using the package plotly ("surface")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1)

 ##(5) interactive plot using the package plotly ("contour")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1,
 type = "contour",
 showscale = TRUE)

 ##(6) interactive plot using the package plotly ("heatmap")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1,
 type = "heatmap",
 showscale = TRUE)
}

}
\seealso{
\linkS4class{RLum.Data.Spectrum}, \link{convert_Wavelength2Energy}, \link{plot_RLum},
\link[graphics:persp]{graphics::persp}, \link[plotly:plot_ly]{plotly::plot_ly}, \link[graphics:contour]{graphics::contour}, \link[graphics:image]{graphics::image}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. plot_RLum.Data.Spectrum(): Plot function for an RLum.Data.Spectrum S4 class object. Function version 0.6.13. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{aplot}
