% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElementsToRanges.R
\name{ElementsToRanges}
\alias{ElementsToRanges}
\title{Create a list of ranges objects from element data}
\usage{
ElementsToRanges(..., element_names = NULL, custom_cols = NULL,
  custom_mcols = NULL)
}
\arguments{
\item{...}{Any number of tab delimited element data files in BED4 or BED12 format}

\item{element_names}{A character vector of names for the element datasets (optional)}

\item{custom_cols}{An integer indicating the number of extra columns in the BED file.}

\item{custom_mcols}{An integer or vector of integers indicating which columns are used for metadata (optional)}
}
\value{
An \emph{ElementRanges} class object: list of GRanges element data objects
}
\description{
Uses tab delimited element data in the form of BED4 or BED12 files to create GRanges element objects
}
\examples{
# Load enhancer and promoter elements into an ElementRanges object
enhancers <- system.file("extdata/elements", "enhancers.bed", package = "LoopRig", mustWork = TRUE)
promoters <- system.file("extdata/elements", "promoters.bed", package = "LoopRig", mustWork = TRUE)
element_ranges <- ElementsToRanges(enhancers, promoters, 
element_names = c("enhancers", "promoters"), 
custom_cols = 1, custom_mcols = 4)
element_ranges
}
