\name{simulated_dataB}
\alias{simulated_dataB}
\docType{data}
\title{
  Simulated Bivariate Semi-competing Risks Data (Set B)
}
\description{
  A simulated dataset for evaluating copula-based semi-competing risks models with semiparametric additive hazards. Each subject may experience disability followed by death, with interval-censored disability times and right-censored death times.
}
\usage{data(simulated_dataB)}
\format{
  A data frame with 2000 subjects and the following variables:
    \describe{
      \item{\code{id}}{subject identifier}
      \item{\code{visit}}{visit index per subject}
      \item{\code{visit_time}}{observation time at each visit (in years)}
      \item{\code{status}}{disability status at visit_time (1 = disabled, 0 = non-disabled)}
      \item{\code{statusD}}{death status at visit_time (1 = dead, 0 = alive)}
      \item{\code{Z1}}{first covariate (binary)}
      \item{\code{Z2}}{second covariate (continuous)}
      \item{\code{Z3}}{third covariate (categorical: 0/1/2)}
      \item{\code{weight}}{sampling weight; constant across visits within a subject}
    }
}
\source{
  Simulated for the manuscript:
    Tao Sun, Huiping Zheng, and Xiaojun Wang (2025+).
  \emph{Decomposing Differences in Cohort Health Expectancy by Cause and Age with Longitudinal Data}.
}
\examples{
  data(simulated_dataB)
  head(simulated_dataB)
}
\keyword{datasets}
