% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_threshold_for_duration.R
\name{threshold_for_duration}
\alias{threshold_for_duration}
\title{Find threshold for given duration}
\usage{
threshold_for_duration(
  Light.vector,
  Time.vector,
  duration,
  comparison = c("above", "below"),
  epoch = "dominant.epoch",
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct},
\link[hms]{hms}, \link[lubridate]{duration}, or \link[base]{difftime}.}

\item{duration}{The duration for which the threshold should be found. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{comparison}{String specifying whether light levels above or below the threshold
should be considered. Can be either \code{"above"} (the default) or \code{"below"}.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{na.rm}{Logical. Should missing values (NA) be removed for the calculation?
Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should a data frame with be returned? If \code{TRUE}, a data
frame with a single column named \verb{threshold_\{comparison\}_for_\{duration\}} will be returned.
Defaults to \code{FALSE}.}
}
\value{
Single numeric value or single column data frame.
}
\description{
This function finds the threshold for which light levels are above/below for
a given duration. This function can be considered as the inverse of
\code{\link{duration_above_threshold}}.
}
\examples{
N <- 60
# Dataset with 30 min < 250lx and 30min > 250lx
dataset1 <-
  tibble::tibble(
    Id = rep("A", N),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(1:N),
    MEDI = sample(c(sample(1:249, N / 2, replace = TRUE), 
                    sample(250:1000, N / 2, replace = TRUE))),
  )

dataset1 \%>\%
  dplyr::reframe("Threshold above which for 30 mins" = 
                   threshold_for_duration(MEDI, Datetime, duration = "30 mins"))

dataset1 \%>\%
  dplyr::reframe("Threshold below which for 30 mins" = 
                   threshold_for_duration(MEDI, Datetime, duration = "30 mins",
                                          comparison = "below"))

dataset1 \%>\%
  dplyr::reframe(threshold_for_duration(MEDI, Datetime, duration = "30 mins",
                                        as.df = TRUE))

}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
