% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnls_intensities.R
\name{nnls_intensities}
\alias{nnls_intensities}
\title{Use non-linear least squares to interpolate intensities}
\usage{
nnls_intensities(
  irradiance_matrix,
  closest_intensities,
  calibration_leds,
  calibration_wavelengths,
  calibration_intensities,
  calibration_irradiances,
  peaks = LightFitR::helio.dyna.leds$wavelength
)
}
\arguments{
\item{irradiance_matrix}{Matrix of intended irradiances. rows = leds and columns = events}

\item{closest_intensities}{Matrix of closest intensities, generated by `internal.closestIntensities`. Same format as `irradiance_matrix`}

\item{calibration_leds}{A numeric vector of LED values from calibration, mapping to intensities and irradiances (i.e. the same length)}

\item{calibration_wavelengths}{A numeric vector of wavelengths from calibration, corresponding to intensities and irradiances}

\item{calibration_intensities}{A numeric vector of intensities (heliospectra units) from calibration}

\item{calibration_irradiances}{A numeric vector of measured irradiances (any units, as long as it is consistently used) from calibration}

\item{peaks}{Vector of length 8 or 9. Containing wavelengths at which each LED peaks.}
}
\value{
Matrix of intensities to set the lights to, to achieve desired irradiances
}
\description{
Use non-linear least squares to interpolate intensities
}
\examples{
# Prep variables
target_irradiance = LightFitR::target_irradiance
closest = LightFitR::example_closest
calib = LightFitR::calibration

# Run the function
nnls_intensities(target_irradiance, closest,
  calib$led, calib$wavelength, calib$intensity, calib$irradiance)

}
