% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.landmark.R
\name{predict.landmark}
\alias{predict.landmark}
\title{Predict the risk of an event for a new individual using the landmark model}
\usage{
\method{predict}{landmark}(object, x_L, x_hor, newdata, cv_fold = NA, ...)
}
\arguments{
\item{object}{Object inheriting the class \code{landmark}, this should be the output from either \code{fit_LME_landmark} or \code{fit_LOCF_landmark}. It should contain a list
of landmark models corresponding to different landmark times \code{x_L}.}

\item{x_L}{Numeric specifying the landmark time. This indicates which landmark model in \code{object} to use.}

\item{x_hor}{Numeric specifying the horizon time. The function assesses the risk of event before this time.}

\item{newdata}{Data frame containing new data to return the risk prediction of the event of interest. The data should be in in long format
and the columns must contain the covariates and time variables that are used to fit the model.
For the LME model this the variables \code{fixed_effects}, \code{random_effects}, \code{fixed_effects_time}, and
\code{random_effects_time}. For the LOCF model this is \code{covariates} and \code{covariates_time}.}

\item{cv_fold}{If cross validation is used to fit \code{fit_LME_landmark} or \code{fit_LOCF_landmark}, then the cross validation fold to use when making risk predictions needs to be specified.}

\item{\dots}{Arguments passed on to \code{riskRegression::predictRisk}}
}
\value{
Data frame \code{newdata} updated to contained a new column \code{event_prediction}
}
\description{
This function predicts the risk of an event for new data using the landmark model fitted by \code{fit_LME_landmark} or \code{fit_LOCF_landmark}.
The 'event' is defined as event for which \code{event_status} is 1.
}
\examples{
library(Landmarking)
data(data_repeat_outcomes)
data_model_landmark_LOCF <-
  fit_LOCF_landmark(
    data_long = data_repeat_outcomes,
    x_L = c(60, 61),
    x_hor = c(65, 66),
    covariates =
      c("ethnicity", "smoking", "diabetes", "sbp_stnd", "tchdl_stnd"),
    covariates_time =
      c(rep("response_time_sbp_stnd", 4), "response_time_tchdl_stnd"),
    k = 10,
    individual_id = "id",
    event_time = "event_time",
    event_status = "event_status",
    survival_submodel = "cause_specific"
  )
 newdata <-
   rbind(
     data.frame(
       id = c(3001, 3001, 3001),
       response_time_sbp_stnd = c(57, 58, 59),
       smoking = c(0, 0, 0),
       diabetes = c(0, 0, 0),
       ethnicity = c("Indian", "Indian", "Indian"),
       sbp_stnd = c(0.45, 0.87, 0.85),
       tchdl_stnd = c(-0.7, 0.24, 0.3),
       response_time_tchdl_stnd = c(57, 58, 59)
     )
   )
 predict(object=data_model_landmark_LOCF,x_L=60,x_hor=62,newdata=newdata,cv_fold=1)
}
