% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances_calculation.R
\name{get_distance}
\alias{get_distance}
\title{Distances between fuel layers}
\usage{
get_distance (gap_cbh_metrics,gaps_perc,step=1,min_height=1.5,verbose=TRUE)
}
\arguments{
\item{gap_cbh_metrics}{data frame with gaps (distances) and fuel base heights (output of [get_gaps_fbhs()] function).
An object of the class text.}

\item{gaps_perc}{data frame with Leaf Area Density (LAD) percentiles for each height values (output of [calculate_gaps_perc()] function).
An object of the class text.}

\item{step}{Numeric value for the actual height bin step (in meters).}

\item{min_height}{Numeric value for the actual minimum base height (in meters).}

\item{verbose}{Logical, indicating whether to display informational messages (default is TRUE).}
}
\value{
A data frame giving distances (and their heights) between fuel layers in meters.
}
\description{
This function calculates distances (and their heights) between fuel layers as the difference between consecutive gaps and fuel bases
(the gap height always must be lower than the fuel base height).
}
\details{
# List of tree metrics:
\itemize{
\item treeID: tree ID with strings and numeric values
\item treeID1: tree ID with only numeric values
\item cbh - Height of the fuel layers base height (m)
\item gap - Height of gaps between consecutive fuel layers (m)
\item dist: Distance between consecutive fuel layers (m)
\item Hdist - Height of the distance between consecutive fuel layers (m)
\item max_height - Maximum height of the tree profile
}
}
\examples{
library(magrittr)
library(gdata)
library(dplyr)

# Before running this example, make sure to run get_gaps_fbhs().
if (interactive()) {
gap_cbh_metrics <- get_gaps_fbhs()
LadderFuelsR::gap_cbh_metrics$treeID <- factor(LadderFuelsR::gap_cbh_metrics$treeID)

# Before running this example, make sure to run calculate_gaps_perc().
LadderFuelsR::gaps_perc$treeID <- factor(LadderFuelsR::gaps_perc$treeID)

trees_name1 <- as.character(gaps_perc$treeID)
trees_name2 <- factor(unique(trees_name1))

metrics_distance_list <- list()

for (i in levels(trees_name2)) {

# Filter data for each tree
tree1 <- gap_cbh_metrics |> dplyr::filter(treeID == i)
tree2 <- gaps_perc |> dplyr::filter(treeID == i)
# Get distance metrics for each tree
metrics_distance <- get_distance(tree1, tree2, step=1, min_height=1.5)
metrics_distance_list[[i]] <- metrics_distance
}
# Combine the individual data frames
distance_metrics <- dplyr::bind_rows(metrics_distance_list)
}
}
\seealso{
\code{\link{get_gaps_fbhs}}

\code{\link{calculate_gaps_perc}}
}
\author{
Olga Viedma, Carlos Silva, JM Moreno and A.T. Hudak
}
