% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Labelling_and_plotting_functions.R
\name{label_relatives}
\alias{label_relatives}
\title{Label Pairwise Relationships Based on Generational Distance and Kinship Coefficient}
\usage{
label_relatives(tbl)
}
\arguments{
\item{tbl}{A tibble or data frame containing at least the following columns:
\describe{
\item{fid}{Column with family identifier (typically the proband's id).}
\item{id1}{Identifier for the first individual.}
\item{id2}{Identifier for the second individual.}
\item{gen.x}{Number of generations between \code{id1} and their most recent common ancestor with \code{id2}.}
\item{gen.y}{Number of generations between \code{id2} and their most recent common ancestor with \code{id1}.}
\item{k}{Estimated kinship coefficient between the two individuals.}
}}
}
\value{
A tibble with the following columns:
\describe{
\item{fid}{Column with family identifier (typically the proband's id).}
\item{id1}{Identifier for the first individual.}
\item{id2}{Identifier for the second individual.}
\item{gen.x}{Generational distance for \code{id1}.}
\item{gen.y}{Generational distance for \code{id2}.}
\item{k}{Kinship coefficient between the two individuals.}
\item{lab}{Assigned relationship label (e.g., \code{"S"}, \code{"P"}, \code{"1C"}, \code{"H1C"}, \code{"2GP"}, etc.).}
}
}
\description{
Assigns standard pedigree relationship labels (e.g., \emph{Parent}, \emph{Child}, \emph{Sibling}, \emph{Grandparent}, \emph{Cousin})
to all pairs of individuals based on their generational distances (\code{gen.x}, \code{gen.y})
and kinship coefficients (\code{k}), typically produced by \code{\link[=get_generations]{get_generations()}}.
}
\details{
This function derives descriptive relationship labels using generational differences
and kinship patterns. The labels are written in a short-hand notation, an explaination of a subset is given below:
\itemize{
\item \emph{P} - Parent
\item \emph{Ch} - Child
\item \emph{S} - Sibling
\item \emph{GP} - Grandparent
\item \emph{Pib} - "Pibling" (parental sibling; aunt/uncle)
\item \emph{Nib} - "Nibling" (sibling's child; niece/nephew)
\item \emph{GCh} - Grandchild
\item \emph{GPib} - Grandpibling (grandparent's sibling)
\item \emph{GNib} - Grandnibling (sibling's grandchild)
\item \emph{C} - Cousin
\item \emph{1C1R} - First Cousin Once Removed
\item \emph{2C2R} - Second Cousin Twice Removed
\item \emph{H} prefix - Half relationships (e.g., \emph{HS} for Half-Sibling)
}
}
\examples{
# see vignette on identifying and labelling relatives

}
\seealso{
\code{\link[=get_generations]{get_generations()}} for computing the generational and kinship inputs used by this function.
}
