% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Labelling_and_plotting_functions.R
\name{get_generations}
\alias{get_generations}
\title{Compute Generational Distances and Kinship Coefficients from a Family Graph}
\usage{
get_generations(fam_graph)
}
\arguments{
\item{fam_graph}{An \link[igraph]{igraph} object representing the family structure,
where directed edges indicate parent–child relationships (from parent to child). See get_family_graphs().}
}
\value{
A tibble with one row per unique pair of individuals and the following columns:
\describe{
\item{id1}{Identifier for the first individual.}
\item{id2}{Identifier for the second individual.}
\item{k}{Estimated kinship coefficient between \code{id1} and \code{id2}.}
\item{gen.x}{Mean number of generations separating \code{id1} from the common ancestor.}
\item{gen.y}{Mean number of generations separating \code{id2} from the common ancestor.}
}
The family graph is centered on a proband (typically the same id as fid),
all relations for the proband can be found by selecting only relations with the
proband's id in the column id1.
}
\description{
Calculates generational distances and kinship coefficients between all pairs of individuals
represented in a directed family graph. The function identifies shortest paths between
individuals, accounts for common ancestors, and derives kinship coefficients based on
the number of generations separating each pair.
}
\examples{
# see vignette on identifying and labelling relatives

}
