% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Stratify Person Table}
\usage{
get_table(persondf, rateobj, strata = dplyr::vars(), batch_size = 500)
}
\arguments{
\item{persondf}{data.frame like object containing one row per person with the required demographic information}

\item{rateobj}{a rate object created by the \code{parseRate} function, or the included rate object \code{us_119ucod_19602021}}

\item{strata}{any additional variables contained in persondf on which to stratify.
Must be wrapped in a \code{vars()} call from \code{dplyr}.}

\item{batch_size}{a number specifying how many persons to stratify at a time. Default is 500}
}
\value{
A data.frame with a row for each strata containing the number of observed
deaths within each of the defined minors/outcomes (\verb{_o1}-\verb{_oxxx}) and the number of person days.
}
\description{
\code{get_table} reads in a data.frame/tibble containing basic demographic information
for each person of the cohort and stratifies the person-time and deaths into 5-year age,
5-year calendar period, race, and sex strata. See \code{Details} for information on how the
person file must be formatted.
}
\details{
The persondf tibble must contain the variables:
\itemize{
\item id,
\item gender (character: 'M'/'F'),
\item race (character: 'W'/'N'),
\item dob (date),
\item pybegin (date),
\item dlo	(date),
\item vs (character: indicator identifying deaths as 'D')
\item rev (numeric: values 5-10),
\item code (character: ICD code)
}
}
\examples{
library(LTASR)
library(dplyr)

#Import example person file
person <- person_example \%>\%
  mutate(dob = as.Date(dob, format='\%m/\%d/\%Y'),
         pybegin = as.Date(pybegin, format='\%m/\%d/\%Y'),
         dlo = as.Date(dlo, format='\%m/\%d/\%Y'))

#Import default rate object
rateobj <- us_119ucod_19602021

#Stratify person table
py_table <- get_table(person, rateobj)

}
