% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margspec.R
\name{marg.spec}
\alias{marg.spec}
\title{Wavelet Packet Marginal Spectra}
\usage{
marg.spec(bas, spec, plot = TRUE)
}
\arguments{
\item{bas}{is a (|b| x 2) matrix containing indices of a wavelet packet basis, where |b| is the number of packets in the basis.}

\item{spec}{is a (|b| x T) matrix containing, in each row, the values of the time-varying spectra for each packet.}

\item{plot}{should a plot of the marginal spectra vs frequency intervals be returned?}
}
\value{
A (|b| x 2) matrix. In the first column the lower frequency relative to each packet is displayed. The second column contains the (time) average spectra.
}
\description{
\code{marg.spec} returns the time-average spectra of LSWP processes for each packet.
}
\details{
This function computes the frequency intervals corresponding to each packet, along with the (time) average spectra for each packet.

This function is used to compute, and eventually plot, the time averaged spectra (or spectral estimate) vs packet frequencies.
The arguments bas and spec shuld be provided as matrices.
}
\examples{

wwb <- get.wavelet.basis(scale = 4)
wwp <- matrix(2^{-(1:4)}, nrow = 4, ncol = 512, byrow = FALSE)
msp <- marg.spec(bas = wwb, spec = wwp, plot = TRUE)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{best.basis}}, \code{\link{get.wavelet.basis}}
}
\author{
Alessandro Cardinali
}
