% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_plot.R
\name{add_plot_labels}
\alias{add_plot_labels}
\title{Convenience function for adding labels to point_plot or others without needing
the ggplot2 + pipe.}
\usage{
add_plot_labels(P, ..., color = NULL)
}
\arguments{
\item{P}{A ggplot2 object, for instance as made with \code{point_plot()} or \code{model_plot()}}

\item{color}{Name for color legend (works for \code{point_plot()})}

\item{\ldots}{Label items (e.g. \code{x = "hello"}) as in ggplot2::labs}
}
\value{
A ggplot graphics object
}
\description{
Convenience function for adding labels to point_plot or others without needing
the ggplot2 + pipe.
}
\examples{
mtcars |> point_plot(mpg ~ hp + cyl) |>
  add_plot_labels(x = "The X axis", y = "Vertical", color = "# cylinders")
}
