% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{SCA}
\alias{SCA}
\title{Single channel algorithm}
\usage{
SCA(TIR = TIR, tau = tau, E = E, dlrad = dlrad, ulrad = ulrad, band = band)
}
\arguments{
\item{TIR}{SpatRaster object, Landsat band 10 or 11}

\item{tau}{Atmospheric transmittance}

\item{E}{SpatRaster object, Land Surface Emissivity calculated according to Van de Griend and Owe 1993 or Valor and Caselles 1996 or Sobrino et al. 2008}

\item{dlrad}{Downwelling radiance calculated from https://atmcorr.gsfc.nasa.gov/}

\item{ulrad}{upwelling radiance calculated from https://atmcorr.gsfc.nasa.gov/}

\item{band}{A string specifying which Landsat 8 thermal band to use. It can be "band 10" or
"band 11"}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Temperature using single channel algorithm
}
\examples{
TIR <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(TIR) = runif(10000, min=27791, max=30878)
E <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(E) = runif(10000, min=0.96, max=0.99)
Ts_SCA <- SCA(TIR = TIR, tau = 0.86, E = E,
		dlrad = 2.17, ulrad = 1.30, band = "band 11")
}
\references{
Jimenez-Munoz, J.C., Cristobal, J., Sobrino, J.A., Sòria, G., Ninyerola, M. and Pons, X., 2008. Revision of the single-channel algorithm for land surface temperature retrieval from Landsat thermal-infrared data. IEEE Transactions on geoscience and remote sensing, 47(1), pp.339-349.
}
