% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifest.R
\name{manifest.lmm}
\alias{manifest.lmm}
\title{Variables Involved in a Linear Mixed Model}
\usage{
\method{manifest}{lmm}(x, effects = "all", original = TRUE, simplify = TRUE, ...)
}
\arguments{
\item{x}{a \code{lmm} object.}

\item{effects}{[character] Should all variable be output (\code{"all"}),
or only those related to the outcome (\code{"outcome"}), mean (\code{"mean"}), variance (\code{"variance"}),
correlation (\code{"correlation"}), time (\code{"time"}), cluster (\code{"cluster"}), strata (\code{"strata"})?}

\item{original}{[logical] Should only the variables present in the original data be output?
When \code{FALSE}, variables internally created are output instead of the original variable for time, cluster, and strata.}

\item{simplify}{[logical] Should the list be converted into a vector if a single \code{effects} is requested?}

\item{...}{not used. For compatibility with the generic function}
}
\value{
A list of character vectors or a character vector.
}
\description{
Extract the variables used by the linear mixed model.
}
\keyword{methods}
