% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{export_chord_diagram}
\alias{export_chord_diagram}
\title{Export interactive HTML chord diagram for ABC connections}
\usage{
export_chord_diagram(
  abc_results,
  output_file = "abc_chord.html",
  top_n = 50,
  min_score = 0.1,
  open = TRUE,
  layout_seed = NULL
)
}
\arguments{
\item{abc_results}{A data frame containing ABC results.}

\item{output_file}{File path for the output HTML file.}

\item{top_n}{Number of top results to visualize.}

\item{min_score}{Minimum score threshold for including connections.}

\item{open}{Logical. If TRUE, opens the HTML file after creation.}

\item{layout_seed}{Optional seed for layout reproducibility. If NULL, no seed is set.}
}
\value{
The file path of the created HTML file (invisibly).
}
\description{
This function creates an HTML chord diagram visualization for ABC connections,
properly coloring the arcs based on whether each term is an A, B, or C term.
}
