% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_model.R
\name{create_comat}
\alias{create_comat}
\title{Create co-occurrence matrix without explicit entity type constraints}
\usage{
create_comat(
  entity_data,
  doc_id_col = "doc_id",
  entity_col = "entity",
  count_col = NULL,
  type_col = "entity_type",
  normalize = TRUE,
  normalization_method = c("cosine", "jaccard", "dice")
)
}
\arguments{
\item{entity_data}{A data frame with document IDs and entities.}

\item{doc_id_col}{Name of the column containing document IDs.}

\item{entity_col}{Name of the column containing entity names.}

\item{count_col}{Name of the column containing entity counts (optional).}

\item{type_col}{Name of the column containing entity types (optional).}

\item{normalize}{Logical. If TRUE, normalizes the co-occurrence matrix.}

\item{normalization_method}{Method for normalization ("cosine", "jaccard", or "dice").}
}
\value{
A co-occurrence matrix with entity types stored as an attribute.
}
\description{
This function creates a co-occurrence matrix from entity data
while preserving entity type information as an attribute without
enforcing type constraints.
}
