% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pefa.R
\name{pefa}
\alias{pefa}
\title{Partially Exploratory Factor Analysis}
\usage{
pefa(
  dat,
  Q = NULL,
  K = 8,
  mjf = 3,
  PPMC = FALSE,
  burn = 5000,
  iter = 5000,
  missing = NA,
  eig_eps = 1,
  sign_eps = 0,
  rfit = TRUE,
  rs = FALSE,
  update = 1000,
  rseed = 12345,
  verbose = FALSE,
  auto_stop = FALSE,
  max_conv = 10,
  digits = 4
)
}
\arguments{
\item{dat}{A \eqn{N \times J} data \emph{matrix} or \emph{data.frame} consisting of the
responses of \eqn{N} individuals to \eqn{J} items.}

\item{Q}{A \eqn{J \times K} design matrix for the loading pattern with \eqn{K} factors and \eqn{J} items for \code{PEFA}.
Elements are 1, -1, and 0 for specified, unspecified, and zero-fixed loadings, respectively. It's not needed
for \code{FEFA}, which is the default. See \code{Examples}.}

\item{K}{Maximum number of factors for selection under \code{FEFA}. Not used for \code{PEFA}.}

\item{mjf}{Minimum number of items per factor.}

\item{PPMC}{logical; \code{TRUE} for conducting posterior predictive model checking.}

\item{burn}{Number of burn-in iterations before posterior sampling.}

\item{iter}{Number of formal iterations for posterior sampling (> 0).}

\item{missing}{Value for missing data (default is \code{NA}).}

\item{eig_eps}{minimum eigenvalue for factor extraction.}

\item{sign_eps}{minimum value for switch sign of loading vector.}

\item{rfit}{logical; \code{TRUE} for providing relative fit (DIC, BIC, AIC).}

\item{rs}{logical; \code{TRUE} for enabling recommendation system.}

\item{update}{Number of iterations to update the sampling information.}

\item{rseed}{An integer for the random seed.}

\item{verbose}{logical; to display the sampling information every \code{update} or not.
\itemize{
    \item \code{Feigen}: Eigenvalue for each factor.
    \item \code{NLA_lg0}: Number of Loading magnitudes > 0 for each factor.
    \item \code{iShrink}: Inverted shrinkage parameter for each factor.
    \item \code{True Fa}: Is the factor identified as true or not.
    \item \code{EPSR & NCOV}: EPSR for each factor & # of convergence.
    \item \code{ROW: LA overflow,sign switch,bk=0, <eig_eps}: Loading overflow, sign switch,
     vector bk=0 and eigenvalue<eig_eps.
}}

\item{auto_stop}{logical; \code{TRUE} for enabling auto stop based on EPSR.}

\item{max_conv}{maximum consecutive number of convergence for auto stop.}

\item{digits}{Number of significant digits to print when printing numeric values.}
}
\value{
\code{pcfa} returns an object of class \code{lawbl} without item intercepts. It contains a lot of information about
the posteriors that can be summarized using \code{\link{summary.lawbl}}.
}
\description{
\code{PEFA} is a partially exploratory approach to factor analysis, which can incorporate
partial knowledge together with unknown number of factors, using bi-level Bayesian regularization.
When partial knowledge is not needed, it reduces to the fully exploratory factor analysis (\code{FEFA}; Chen, 2021).
A large number of factors can be imposed for selection where true factors will be identified against spurious factors.
The loading vector is reparameterized to tackle model sparsity at the factor and loading levels
with the multivariate spike and slab priors. Parameters are obtained by sampling from the posterior
distributions with the Markov chain Monte Carlo (MCMC) techniques. The estimation results can be summarized
with \code{\link{summary.lawbl}} and the trace or density of the posterior can be plotted with \code{\link{plot_lawbl}}.
}
\examples{
\donttest{
#####################################################
#  Example 1: Fully EFA                             #
#####################################################

dat <- sim18cfa0$dat

m0 <- pefa(dat = dat, K=5, burn = 2000, iter = 2000,verbose = TRUE)
summary(m0) # summarize basic information
summary(m0, what = 'qlambda') #summarize significant loadings in pattern/Q-matrix format
summary(m0, what = 'phi') #summarize factorial correlations
summary(m0, what = 'eigen') #summarize factorial eigenvalue

##########################################################
#  Example 2: PEFA with two factors partially specified  #
##########################################################

J <- ncol(dat)
K <- 5
Q<-matrix(-1,J,K);
Q[1:2,1]<-Q[7:8,2]<-1
Q

m1 <- pefa(dat = dat, Q = Q,burn = 2000, iter = 2000,verbose = TRUE)
summary(m1)
summary(m1, what = 'qlambda')
summary(m1, what = 'phi')
summary(m1,what='eigen')
}
}
\references{
Chen, J. (2021). A Bayesian regularized approach to exploratory factor analysis in one step.
 \emph{Structural Equation Modeling: A Multidisciplinary Journal},
  28(4), 518-528. DOI: 10.1080/10705511.2020.1854763.

Chen, J. (In Press). Fully and partially exploratory factor analysis with bi-level Bayesian regularization.
 \emph{Behavior Research Methods}.
}
