% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KneeArrow.R
\name{findCutoff}
\alias{findCutoff}
\title{Finds cutoff point on knee curve}
\usage{
findCutoff(x, y, method = "first", frac.of.steepest.slope = 0.5)
}
\arguments{
\item{x}{vector of x coordinates of points around curve}

\item{y}{vector of y coordinates of points around curve}

\item{method}{the method to define the knee point.
Value can be "first" for first derivative cutoff or "curvature" for maximum curvature cutoff.}

\item{frac.of.steepest.slope}{the slope at the cutoff point relative to the steepest (positive or negative) slope on the curve.
Only used if method is set to "first". Can be set to any number > 0 or <= 1. If the knee curve is increasing and concave down,
then lower numbers will lead to higher knee points, and higher numbers will lead to lower knee points.}
}
\value{
a list containing the (x, y) coordinates of the knee point chosen using the specified method
}
\description{
Finds cutoff point on knee curve
}
\examples{
# Generate some knee data
x <- runif(100, min=-3, max=3)
y <- -exp(-x) * (1+rnorm(100)/3)
plot(x, y)
# Plot knee points calculated using two different methods
points(findCutoff(x,y), col="red", pch=20, cex=3)
points(findCutoff(x,y, method="curvature"), col="blue", pch=20, cex=3)
}
