% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_kb.R
\name{summary_kb}
\alias{summary_kb}
\title{Summarize Objects Generated by the Keyboard Design Package}
\usage{
summary_kb(object, ...)
}
\arguments{
\item{object}{The object (returned by another function) to be described.}

\item{...}{Ignored arguments.}
}
\value{
This function helps users to interpret the objects returned by other
  Keyboard package functions.
}
\description{
This function generates a descriptive summary for objects returned by other functions.\cr
}
\details{
Unpacks objects returned by other functions with descriptions of
their results. The following functions are supported:\cr
(1) get.oc.kb(), get.oc.comb.kb(), get.oc.obd.kb(), and get.oc.obd2.kb(), which yield the operating
    characteristics of trials simulated using the Keyboard design.\cr
(2) select.mtd.kb() and select.mtd.comb.kb(), which yield the MTD and other
    statistics.\cr
(3) next.comb.kb(), which indicates the dose combination to administer to
    the next cohort. \cr
(4) select.obd.kb(), which yields the OBD.
}
\examples{
\donttest{
### Single-agent trial ###

## Summarize the object returned by get.oc.kb()
oc.single <- get.oc.kb(target=0.3, p.true=c(0.05, 0.15, 0.3, 0.45, 0.6),
                       ncohort=10, cohortsize=3, ntrial=1000)
summary_kb(oc.single)


## Summarize the object returned by select.mtd.kb()
n <- c(3, 3, 15, 9, 0)
y <- c(0, 0, 4, 4, 0)
sel.single <- select.mtd.kb(target=0.3, npts=n, ntox=y)
summary_kb(sel.single)



## Summarize the object returned by select.mtd.comb.kb()
n <- matrix(c(6, 3, 0, 0,
              6, 24, 9, 0,
              0, 0, 0, 0), ncol=4, byrow=TRUE)
y <- matrix(c(0, 0, 0, 0,
              1, 5, 4, 0,
              0, 0, 0, 0), ncol=4, byrow=TRUE)
sel.comb <- select.mtd.comb.kb(target=0.25, npts=n, ntox=y)
summary_kb(sel.comb)


## Summarize the object returned by next.comb.kb()
n <- matrix(c(3, 0, 0, 0,
              0, 0, 0, 0,
              0, 0, 0, 0), ncol=4, byrow=TRUE)
y <- matrix(c(0, 0, 0, 0,
              0, 0, 0, 0,
              0, 0, 0, 0), ncol=4, byrow=TRUE)
nxt.comb <- next.comb.kb(target=0.25, npts=n, ntox=y, dose.curr=c(1, 1))
summary_kb(nxt.comb)

## get.oc.obd
toxicity.low <- 0.15
toxicity.moderate <- 0.25
toxicity.high <- 0.35
efficacy.low <- 0.25
efficacy.moderate <- 0.45
efficacy.high <- 0.65
target.toxicity<-0.20
target.efficacy<-0.40
p.true <-c(0.08,0.20,0.60,0.80)
q.true <- c(0.25,0.40,0.25,0.50)
oc.obd.kb <- get.oc.obd.kb(toxicity.low = toxicity.low,
             toxicity.moderate= toxicity.moderate,
             toxicity.high = toxicity.high,
             efficacy.low = efficacy.low,
             efficacy.moderate = efficacy.moderate,
             efficacy.high = efficacy.high,
             target.toxicity=target.toxicity,
             target.efficacy= target.efficacy,
             p.true= p.true, q.true= q.true)
summary_kb(oc.obd.kb)

## OBD selection
target.toxicity<-0.3
target.efficacy<-0.4
npts <- c(3,6,12,3,3)
ntox <-  c(1,2,4,2,3)
neff <-  c(0,0,5,1,1)
obd <- select.obd.kb (target.toxicity=target.toxicity,
       target.efficacy= target.efficacy, npts = npts,
       ntox = ntox, neff =  neff)
summary_kb(obd)
}

}
\seealso{
\code{\link{plot_kb}}
}
\author{
Xiaomeng Yuan, Chen Li, Hongying Sun, Li Tang and Haitao Pan
}
