% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualsKspm.R
\name{residuals.kspm}
\alias{residuals.kspm}
\title{Extract residuals from a Kernel Semi Parametric Model}
\usage{
\method{residuals}{kspm}(object, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{...}{additional optional argument (currently unused).}
}
\value{
A vector of residuals. The vector length is the number of observations used in model coefficients estimation (see \link{nobs.kspm}).
}
\description{
Returns the vector of residuals for a model fit of class "kspm".
}
\examples{
x <- 1:15
y <- 3*x + rnorm(15, 0, 2)
fit <- kspm(y, kernel = ~ Kernel(x, kernel.function = "linear"))
residuals(fit)

}
\seealso{
\link{kspm} for fitting model, \link{nobs.kspm}, \link{rstandard.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
