% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playlists.R
\name{getPlaylistsNamesearch}
\alias{getPlaylistsNamesearch}
\title{Search Jamendo database for playlists with certain name}
\usage{
getPlaylistsNamesearch(
  namesearch,
  limit = 10,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID")
)
}
\arguments{
\item{namesearch}{String to search for}

\item{limit}{Integer to set the number of displayed search results. Maximum value is 200.}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about playlists with certain name.
See \url{https://developer.jamendo.com/v3.0/playlists} for more information.
}
\description{
Search Jamendo database for playlists with certain name
}
\examples{
\donttest{
##Example
 playlists <- getPlaylistsNamesearch("chill", limit = 3)
}
}
