% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jous.R
\name{predict.jous}
\alias{predict.jous}
\title{Create predictions}
\usage{
\method{predict}{jous}(object, X, type = c("response", "prob"), ...)
}
\arguments{
\item{object}{An object of class \code{jous} returned by the \code{jous} function.}

\item{X}{A design matrix of predictors.}

\item{type}{The type of prediction to return.  If \code{type="response"}, a
class label of -1 or 1 is returned.  If \code{type="prob"}, the
probability \eqn{p(y=1|x)} is returned.}

\item{...}{\dots}
}
\value{
Returns a vector of class predictions if \code{type="response"}, or a
         vector of class probabilities \eqn{p(y=1|x)} if \code{type="prob"}.
}
\description{
Makes a prediction on new data for a given fitted \code{jous} model.
}
\examples{
\dontrun{
# Generate data from Friedman model #
set.seed(111)
dat = friedman_data(n = 500, gamma = 0.5)
train_index = sample(1:500, 400)

# Apply jous to adaboost classifier
class_func = function(X, y) adaboost(X, y, tree_depth = 2, n_rounds = 100)
pred_func = function(fit_obj, X_test) predict(fit_obj, X_test)

jous_fit = jous(dat$X[train_index,], dat$y[train_index], class_func,
                pred_func, keep_models=TRUE)
# get class prediction
yhat = predict(jous_fit, dat$X[-train_index, ])
# get probability estimate
phat = predict(jous_fit, dat$X[-train_index, ], type="prob")
}
}
