% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ivs2likert.R
\docType{methods}
\name{ivs2likert}
\alias{ivs2likert}
\alias{ivs2likert,IntervalData-method}
\alias{ivs2likert,IntervalList-method}
\alias{ivs2likert,IntervalMatrix-method}
\title{Convert interval-valued responses into their equivalent numerically encoded
Likert-type scale answers with minimum \eqn{\theta}-distance criterion}
\usage{
ivs2likert(x, k = 7, minimum = 1, maximum = 7, theta = 1)
}
\arguments{
\item{x}{Either a single interval or either a list or matrix with several
intervals stored as an \code{IntervalData} object or as an
\code{IntervalList} or \code{IntervalMatrix} instance.}

\item{k}{A single positive integer number stored as a \code{numeric} object
which indicates the number of different Likert-type responses to be
considered. By default, \code{k = 7}.}

\item{minimum}{A single real number indicating the lower bound of the
interval-valued scale used saved as a unique \code{numeric}
value. By default, \code{minimum = 1}.}

\item{maximum}{A single real number indicating the upper bound of the
interval-valued scale used saved as a unique \code{numeric}
value. By default, \code{maximum = 7}.}

\item{theta}{A single positive real number stored as a unique \code{numeric}
value which is used for distance computations. By default,
\code{theta = 1}.}
}
\value{
This function returns the nearest Likert-type responses for the given
interval-valued data following the minimum \eqn{\theta}-distance criterion
stored either as a \code{numeric} object if \code{x} argument is a single
interval or a list of intervals, that is, an \code{IntervalData} or
\code{IntervalList} instance, or either as a \code{data.frame} object whether
\code{x} is a matrix of intervals, that is, an \code{IntervalMatrix} object.
}
\description{
This function allows to associate each nonempty compact real interval
collected as a response in a questionnaire designed with interval-valued
scales to its equivalent numerically encoded Likert-type scale answer
following the minimum \eqn{\theta}-distance criterion.
}
\details{
If a \eqn{k}-point Likert-type scale with reference interval \eqn{[l,u]} is
considered, then the minimum distance criterion consists on associating each
interval-valued scale response with the real number in the set defined by
\eqn{\{L_{1},L_{2},\ldots,L_{k}\},} where each \eqn{L_{i}} is defined as
follows, \deqn{L_{i}=l+(i-1)\frac{u-l}{k-1}, \qquad i=1,2,\ldots,k,}
with the smallest \eqn{\theta}-distance to the given data. That is,
each interval \eqn{A} is associated with the real number \eqn{L(A)}
such that \deqn{L(A)=\arg\min_{L\in\{L_{1},L_{2},\ldots, L_{k}\}} d_{\theta}
\left(A,\{L\}\right).} If ties are produced, they are broken at random.
}
\examples{
## Some ivs2likert() examples using an interval-valued scale bounded
## between 0 and 10, a 11-point Likert scale, and rho2 distance (theta = 1)

## A single interval-valued response
i <- IntervalData(3, 3.2)
ivs2likert(i, k = 11, minimum = 0, maximum = 10)

## A list of interval-valued responses
list <- IntervalList(c(3, 8.7), c(3.2, 9))
ivs2likert(list, k = 11, minimum = 0, maximum = 10)

## A matrix of interval-valued responses
matrix <- IntervalMatrix(matrix(c(1, 2.6, 1.5, 3, 3.8, 6, 4, 7), 2, 4))
ivs2likert(matrix, k = 11, minimum = 0, maximum = 10)
}
\seealso{
Interval-valued responses can be also associated to their corresponding
answers in a visual analogue scale through the mid-point criterion
implemented in the \code{\link{ivs2vas}()} function.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
