% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFL.core_ex.R
\encoding{utf8}
\name{INFL.core_ex}
\alias{INFL.core_ex}
\title{Computes the core inflation using the subitem exclusion method}
\usage{
INFL.core_ex(subits.var, weights, info, n.blocks = 4, alpha = 2)
}
\arguments{
\item{subits.var}{A \code{ts}. Inflation subitems' variation.}

\item{weights}{A \code{ts}. Each subitem corresponding weights. If missing, all items get the same weight.}

\item{info}{A \code{data.frame}. Subitem metadata table containing their codes and descriptions.}

\item{n.blocks}{An \code{integer}. Partitions' number inside the temporal window.}

\item{alpha}{An \code{integer}. Significance level in percentage.}
}
\description{
Computes the core inflation using the subitem exclusion method
}
\examples{
ipca <- Inflation::ipca_sub
ipc.ex1 <- Inflation::INFL.core_ex(subits.var = ipca$ipca_ts,
                                   weights = ipca$weights_ts,
                                   info = ipca$cod,
                                   n.blocks = 4,
                                   alpha = 2)

}
\keyword{core}
\keyword{exclusion}
