% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{road_population_tbl_df}
\alias{road_population_tbl_df}
\title{India Road and Population Data by State}
\format{
A tibble with 36 observations and 27 variables:
\describe{
  \item{Name of the States}{Name of the state or union territory (character)}
  \item{National Highways}{Length of national highways in kilometers (numeric)}
  \item{State Highways}{Length of state highways in kilometers (numeric)}
  \item{District Roads}{Length of district roads in kilometers (numeric)}
  \item{Rural Roads}{Length of rural roads in kilometers (numeric)}
  \item{Urban roads}{Length of urban roads in kilometers (numeric)}
  \item{Project Roads}{Length of project roads in kilometers (numeric)}
  \item{Total road Length}{Total length of roads in kilometers (numeric)}
  \item{Total Area}{Total area of the state/UT in square kilometers (numeric)}
  \item{Urban Road density}{Density of urban roads (numeric)}
  \item{Rural Road density}{Density of rural roads (numeric)}
  \item{Entire State Road length per 1000 sq km}{Road length per 1000 square kilometers of entire state (numeric)}
  \item{Urban Road lngth per 1000 sq km}{Urban road length per 1000 square kilometers (numeric)}
  \item{Rural Road lngth per 1000 sq km}{Rural road length per 1000 square kilometers (numeric)}
  \item{Road Density}{Overall road density (numeric)}
  \item{Road Density per 1000 Sq. Km - National Highways}{National highways road density per 1000 sq km (numeric)}
  \item{Road Density per 1000 Sq. Km - State Highways}{State highways road density per 1000 sq km (numeric)}
  \item{Road Density per 1000 Sq. Km - District Roads}{District roads road density per 1000 sq km (numeric)}
  \item{Road Density per 1000 Sq. Km - Rural Roads}{Rural roads road density per 1000 sq km (numeric)}
  \item{Road Density per 1000 Sq. Km - Urban roads}{Urban roads road density per 1000 sq km (numeric)}
  \item{Road Density per 1000 Sq. Km - Project Roads}{Project roads road density per 1000 sq km (numeric)}
  \item{Area}{Area of the state/UT (numeric)}
  \item{Rural Area (2011 census)}{Rural area in 2011 census (numeric)}
  \item{Urban Area (2011 census)}{Urban area in 2011 census (numeric)}
  \item{Rural Pop (2011 census)}{Rural population according to 2011 census (numeric)}
  \item{Urban Pop (2011 census)}{Urban population according to 2011 census (numeric)}
  \item{Total  Population}{Total population of the state/UT (numeric)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/zsinghrahulk/india-roadforpopulation-data}
}
\usage{
data(road_population_tbl_df)
}
\description{
This dataset, road_population_tbl_df, is a tibble containing detailed information about road infrastructure
and population data for Indian states. It includes lengths of various road types, road density metrics,
area statistics, and rural and urban population data according to the 2011 census.
The dataset preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'road_population_tbl_df' to maintain consistency with the naming
conventions in the IndiAPIs package. The suffix 'tbl_df' indicates that this is a tibble
data frame. The original content has not been modified in any way.
}
