% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shares.R
\name{predictedShares}
\alias{predictedShares}
\title{Predicted shares for predicted share relative price dissimilarity}
\usage{
predictedShares(x, pvar, qvar, pervar, prodID)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable. For
elementary indexes a quantity variable is not required for the calculations
and you must specify qvar = "".}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}
}
\value{
a list of matrices
}
\description{
You should not need to call this function directly unless the shares
themselves are of interest. Other functions will call this function internally.
}
