/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3DTest;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix3D;

public class DenseLargeFloatMatrix3DTest
extends FloatMatrix3DTest {
    public DenseLargeFloatMatrix3DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseLargeFloatMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
        this.B = new DenseLargeFloatMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
    }

    public void testDct3() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((WrapperFloatMatrix3D)this.A).dct3(true);
        ((WrapperFloatMatrix3D)this.A).idct3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testDst3() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((WrapperFloatMatrix3D)this.A).dst3(true);
        ((WrapperFloatMatrix3D)this.A).idst3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testDht3() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((WrapperFloatMatrix3D)this.A).dht3();
        ((WrapperFloatMatrix3D)this.A).idht3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testFft3() {
        int n;
        int n2;
        int n3;
        int n4 = 16;
        int n5 = 32;
        int n6 = 64;
        FloatMatrix3D floatMatrix3D = new DenseLargeFloatMatrix3D(n4, n5, n6);
        FloatMatrix3D floatMatrix3D2 = floatMatrix3D.copy();
        ((WrapperFloatMatrix3D)floatMatrix3D).fft3();
        ((WrapperFloatMatrix3D)floatMatrix3D).ifft3(true);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D2.getQuick(n3, n2, n), (float)floatMatrix3D.getQuick(n3, n2, n), (float)this.TOL);
                }
            }
        }
        floatMatrix3D = floatMatrix3D.viewDice(2, 1, 0);
        floatMatrix3D2 = floatMatrix3D.copy();
        ((WrapperFloatMatrix3D)floatMatrix3D).fft3();
        ((WrapperFloatMatrix3D)floatMatrix3D).ifft3(true);
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n4; ++n) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D2.getQuick(n3, n2, n) - floatMatrix3D.getQuick(n3, n2, n)), (float)this.TOL);
                }
            }
        }
    }

    public void testDct2Slices() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((WrapperFloatMatrix3D)this.A).dct2Slices(true);
        ((WrapperFloatMatrix3D)this.A).idct2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testDst2Slices() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((WrapperFloatMatrix3D)this.A).dst2Slices(true);
        ((WrapperFloatMatrix3D)this.A).idst2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testDft2Slices() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((WrapperFloatMatrix3D)this.A).dht2Slices();
        ((WrapperFloatMatrix3D)this.A).idht2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeFloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testGetFft3() {
        DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = ((WrapperFloatMatrix3D)this.A).getFft3();
        denseLargeFComplexMatrix3D.ifft3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseLargeFComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)fArray[0], (float)this.TOL);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }

    public void testGetIfft3() {
        DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = ((WrapperFloatMatrix3D)this.A).getIfft3(true);
        denseLargeFComplexMatrix3D.fft3();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseLargeFComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)fArray[0], (float)this.TOL);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }

    public void testGetFft2Slices() {
        DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = ((WrapperFloatMatrix3D)this.A).getFft2Slices();
        denseLargeFComplexMatrix3D.ifft2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseLargeFComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)fArray[0], (float)this.TOL);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }

    public void testGetIfft2Slices() {
        DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = ((WrapperFloatMatrix3D)this.A).getIfft2Slices(true);
        denseLargeFComplexMatrix3D.fft2Slices();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseLargeFComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)fArray[0], (float)this.TOL);
                    DenseLargeFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }
}

